<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:strip-space elements="*"/>
    <xsl:variable name="linearUnit">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">st</xsl:when>
            <xsl:otherwise>m</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="areaUnit1">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">st2</xsl:when>
            <xsl:otherwise>m2</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="areaUnit2">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">akr</xsl:when>
            <xsl:otherwise>ha</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <xsl:choose>
            <xsl:when test="$xslShowHelp = 'true'">
                <xsl:call-template name="StyleSheetHelp"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="InRoads">
                    <xsl:text/>

                    <xsl:text>                        Vytýčení trasy&#xd;</xsl:text>
                    <xsl:text>            Datum výpisu:  </xsl:text>
                    <xsl:value-of select="cif:date()"/>
                    <xsl:text> Čas:  </xsl:text>
                    <xsl:value-of select="cif:time()"/>
                    <xsl:text>&#xd;&#xd;</xsl:text>

                    <xsl:for-each select="GeometryProject">
                        <xsl:text>Projekt:  </xsl:text><xsl:value-of select="@name"/>
                        <xsl:text>&#xd;Popis:  </xsl:text><xsl:value-of select="@description"/>
                        <xsl:text>&#xd;Název souboru:  </xsl:text><xsl:value-of select="@file"/>
                        <xsl:text>&#xd;Poslední revize:  </xsl:text>
                        <xsl:value-of select="@lastRevisedBy"/><xsl:text> </xsl:text>
                        <xsl:value-of select="@lastRevisedDate"/>
                        <xsl:text>  Poznámka:  Všechny jednotky tohoto výpisu jsou</xsl:text>
                        <xsl:choose>
                            <xsl:when test="//@linearUnits = 'Metric'"> v metrech, </xsl:when>
                            <xsl:otherwise> ve stopách, </xsl:otherwise>
                        </xsl:choose>
                        <xsl:text>pokud není specifikováno jinak.&#xd;</xsl:text>

                        <xsl:for-each select="HorizontalAlignment">
                            <xsl:text>&#xd;Název trasy:  </xsl:text>
                            <xsl:value-of select="@name"/>
                            <xsl:text>&#xd;Popis trasy:  </xsl:text>
                            <xsl:value-of select="@description"/>
                            <xsl:text>&#xd;&#xd;</xsl:text>
                            <xsl:text>                                           - -  S o u ř a d n i c e  - -&#xd;</xsl:text>
                            <xsl:text>Bod          Směrník          Vzdálenost     Y                  X&#xd;</xsl:text>
                            <xsl:text>----------   -------------    ----------     -----------        -----------&#xd;</xsl:text>
                            <xsl:apply-templates select="//HorizontalLine | //HorizontalCircle | //HorizontalSpiral"/>
                            <xsl:text>&#xd;</xsl:text>
                            <xsl:if test="@northingClosingError">
                                <xsl:text>Y chyba:  </xsl:text>
                                <xsl:value-of select="cif:columnDoubleFormat(number(@northingClosingError), 16)"/>
                                <xsl:text> </xsl:text>
                                <xsl:value-of select="$linearUnit"/>
                                <xsl:text>     X chyba:  </xsl:text>
                                <xsl:value-of select="cif:columnDoubleFormat(number(@eastingClosingError), 15)"/>
                                <xsl:text> </xsl:text>
                                <xsl:value-of select="$linearUnit"/>
                                <xsl:text>&#xd;Směr uzavření:  </xsl:text>
                                <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@closingDirection))), 12)"/>
                                <xsl:text>     Délka uzavření:  </xsl:text>
                                <xsl:value-of select="cif:columnDoubleFormat(number(@closingDistance), 12)"/>
                                <xsl:text> </xsl:text>
                                <xsl:value-of select="$linearUnit"/>
                                <xsl:text>&#xd;Přesnost:  </xsl:text>
                                <xsl:value-of select="cif:columnDoubleFormat(number(@closingPrecision), 17)"/>
                            </xsl:if>
                            <xsl:text>&#xd;</xsl:text>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="HorizontalLine">
        <xsl:if test="position() = 1">
            <xsl:text>Začátek - </xsl:text>
            <xsl:value-of select="cif:columnFormat(cif:pointType(string(Start/@pointType)), 3)"/>
            <xsl:text> (</xsl:text>
            <xsl:choose>
                <xsl:when test="Start/@name">
                    <xsl:value-of select="cif:columnFormat(string(Start/@name), 4)"/>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
            </xsl:choose>
            <xsl:text>)</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(Start/@northing), 34)"/>
            <xsl:value-of select="cif:columnDoubleFormat(number(Start/@easting), 19)"/>
            <xsl:text>&#xd;</xsl:text>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(End/@pointType)), 3)"/>
        <xsl:text> (</xsl:text>
        <xsl:choose>
            <xsl:when test="End/@name">
                <xsl:value-of select="cif:columnFormat(string(End/@name), 4)"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@direction))), 16)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(@length), 11)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(End/@northing), 17)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(End/@easting), 19)"/>
        <xsl:text>&#xd;</xsl:text>
    </xsl:template>

    <xsl:template match="HorizontalCircle">
        <xsl:if test="position() = 1">
            <xsl:text>Začátek - </xsl:text>
            <xsl:value-of select="cif:columnFormat(cif:pointType(string(Start/@pointType)), 3)"/>
            <xsl:text> (</xsl:text>
            <xsl:choose>
                <xsl:when test="Start/@name">
                    <xsl:value-of select="cif:columnFormat(string(Start/@name), 4)"/>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
            </xsl:choose>
            <xsl:text>)</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(Start/@northing), 36)"/>
            <xsl:value-of select="cif:columnDoubleFormat(number(Start/@easting), 19)"/>
            <xsl:text>&#xd;</xsl:text>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(Center/@pointType)), 3)"/>
        <xsl:text> (</xsl:text>
        <xsl:choose>
            <xsl:when test="Center/@name">
                <xsl:value-of select="cif:columnFormat(string(Center/@name), 4)"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@radialDirectionStart))), 16)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(@radius), 11)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(Center/@northing), 17)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(Center/@easting), 19)"/>
        <xsl:text>&#xd;      Úhel:</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(cif:angularFormat(number(@delta))), 11)"/>
        <xsl:choose>
            <xsl:when test="@rotationDirection = 'ccw'"><xsl:text>  Vlevo</xsl:text></xsl:when>
            <xsl:otherwise><xsl:text> Vpravo</xsl:text></xsl:otherwise>
        </xsl:choose>
        <xsl:text>  Poloměr:</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(@radius), 9)"/>
        <xsl:text>      Délka:</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(@length), 10)"/>
        <xsl:text>&#xd;      Tečna:</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(@tangentLength), 9)"/>
        <xsl:text>          Tětiva:</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(@chord), 10)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(End/@pointType)), 3)"/>
        <xsl:text> (</xsl:text>
        <xsl:choose>
            <xsl:when test="End/@name">
                <xsl:value-of select="cif:columnFormat(string(End/@name), 4)"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>)</xsl:text>
            <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@radialDirectionEnd))), 16)"/>
            <xsl:value-of select="cif:columnDoubleFormat(number(@radius), 11)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(End/@northing), 17)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(End/@easting), 19)"/>
        <xsl:text>&#xd;</xsl:text>
    </xsl:template>

    <xsl:template match="HorizontalSpiral">
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(Start/@pointType)), 3)"/>
        <xsl:text> (</xsl:text>
        <xsl:choose>
            <xsl:when test="Start/@name">
                <xsl:value-of select="cif:columnFormat(string(Start/@name), 4)"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(Start/@northing), 44)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(Start/@easting), 19)"/>
        <xsl:text>&#xd;&#xd;</xsl:text>
        <xsl:if test="position() = last()">
            <xsl:value-of select="cif:columnFormat(cif:pointType(string(End/@pointType)), 3)"/>
            <xsl:text> (</xsl:text>
            <xsl:choose>
                <xsl:when test="End/@name">
                    <xsl:value-of select="cif:columnFormat(string(End/@name), 4)"/>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
            </xsl:choose>
            <xsl:text>)</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(End/@northing), 44)"/>
            <xsl:value-of select="cif:columnDoubleFormat(number(End/@easting), 19)"/>
            <xsl:text>&#xd;&#xd;</xsl:text>
        </xsl:if>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <xsl:text>Poznámky&#xd;&#xd;</xsl:text>
        <xsl:text>Pro tento výpis musíte vybrat nejméně&#xd;</xsl:text>
        <xsl:text>jeden Civil prvek směrové geometrie.&#xd;&#xd;</xsl:text>
        <xsl:text>Copyright 2012 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
